local t = Def.ActorFrame{
	Def.Quad{
		Name="Fallback";
		InitCommand=cmd(Center;FullScreen;diffuse,color("0,0,0,1"));
	};
}

if GAMESTATE:IsCourseMode() then
	local curCourse = GAMESTATE:GetCurrentCourse()
	if curCourse then
		if curCourse:HasBackground() then
			-- load course bg
			t[#t+1] = Def.Sprite {
				InitCommand=cmd(Center);
				BeginCommand=function(self)
					self:Load( curCourse:GetBackgroundPath() )
				end;
				OnCommand=function(self)
					if PREFSMAN:GetPreference("StretchBackgrounds") then self:SetSize(SCREEN_WIDTH,SCREEN_HEIGHT)
					else self:scale_or_crop_background()
					end
				end;
		};
		else
			t[#t+1] = LoadActor(THEME:GetPathG("Common fallback","background"))..{
				InitCommand=cmd(Center);
			};
		end
	end
else
	t[#t+1] = Def.Sprite {
		InitCommand=cmd(Center);
		BeginCommand=cmd(LoadFromCurrentSongBackground);
		OnCommand=function(self)
			if PREFSMAN:GetPreference("StretchBackgrounds") then self:SetSize(SCREEN_WIDTH,SCREEN_HEIGHT)
			else self:scale_or_crop_background()
			end
		end;
	};
end

return t